/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.bookmarks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.datasource.DataSetSelector;
import org.das2.util.LoggerManager;

public class DelayMenu
extends JMenu {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.bookmarks");
    static final int MAX_TITLE_LEN = 50;
    static final int MAX_LABEL_LEN = 30;
    static final int TRIM_TAIL_LEN = 10;
    private static boolean oldLogic = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void calculateMenu(JMenu menu, List<Bookmark> bookmarks, final ActionListener a) {
        List<Bookmark> content = bookmarks;
        for (int i = 0; i < content.size(); ++i) {
            Icon icon;
            String tooltip;
            final Bookmark book = content.get(i);
            if (book instanceof Bookmark.Item) {
                String title = book.getTitle();
                if (title.length() > 50) {
                    title = title.substring(0, 50) + "...";
                }
                if (book.isHidden()) continue;
                JMenuItem mi = new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        ActionEvent ne = new ActionEvent(e.getSource(), e.getID(), ((Bookmark.Item)book).getUri());
                        a.actionPerformed(ne);
                    }
                });
                mi.setToolTipText(((Bookmark.Item)book).getUri());
                if (book.getIcon() != null) {
                    mi.setIcon(AutoplotUtil.scaleIcon(book.getIcon(), -1, 16));
                }
                menu.add(mi);
                continue;
            }
            Bookmark.Folder folder = (Bookmark.Folder)book;
            String title = book.getTitle();
            if (title.length() > 50) {
                title = title.substring(0, 50) + "...";
            }
            if (folder.getRemoteUrl() != null) {
                if (folder.getRemoteStatus() == 0) {
                    tooltip = "Bookmark folder based on contents of remote URL <br>%{URL}";
                    icon = null;
                } else if (folder.getRemoteStatus() == -1) {
                    tooltip = "Checking to see if remote bookmark list has changed.<br>%{URL}";
                    icon = AutoplotUI.BUSY_OPAQUE_ICON;
                } else {
                    if (folder.getRemoteStatus() != 1) throw new IllegalArgumentException("internal error...");
                    tooltip = "Using cached version because <br>remote folder based on contents of remote URL <br>%{URL}<br>which is not available. <br>" + folder.getRemoteStatusMsg();
                    icon = AutoplotUI.WARNING_ICON;
                }
            } else {
                tooltip = "";
                icon = null;
            }
            if (folder.isHidden()) continue;
            String titl = title.trim();
            if (titl.length() > 30) {
                titl = titl.substring(0, 17) + "..." + titl.substring(titl.length() - 10, titl.length());
            }
            JMenu subMenu = new JMenu(titl);
            DelayMenu.calculateMenu(subMenu, folder.getBookmarks(), a);
            subMenu.setIcon(icon);
            if (tooltip.contains("%{URL}")) {
                tooltip = tooltip.replace("%{URL}", folder.getRemoteUrl());
            }
            if (folder.getRemoteUrl() != null) {
                if (book.getDescription() != null && book.getDescription().length() > 0) {
                    String ttext = "<html><i>" + title + "<br>" + book.getDescription() + "</i>";
                    subMenu.setToolTipText(ttext + "<br>" + tooltip);
                } else if (tooltip.length() > 0) {
                    subMenu.setToolTipText("<html>" + tooltip);
                }
            }
            menu.add(subMenu);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void calculateMenu(JMenu menu, List<Bookmark> bookmarks, int treeDepth, final DataSetSelector sel, final AutoplotUI ui) {
        List<Bookmark> content = bookmarks;
        for (int i = 0; i < content.size(); ++i) {
            Icon icon;
            String tooltip;
            final Bookmark book = content.get(i);
            if (book instanceof Bookmark.Item) {
                String title = book.getTitle();
                if (title.length() > 50) {
                    title = title.substring(0, 50) + "...";
                }
                if (book.isHidden()) continue;
                JMenuItem mi = new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        if (oldLogic || ui == null) {
                            sel.setValue(((Bookmark.Item)book).getUri());
                            sel.maybePlot(e.getModifiers());
                        } else {
                            String uri = ((Bookmark.Item)book).getUri();
                            if (uri.endsWith(".jy")) {
                                ui.runScriptTools(uri);
                                return;
                            }
                            if (ui.getDom().getDataSourceFilters().length == 1 && ui.getDom().getDataSourceFilters(0).getUri().length() == 0) {
                                sel.setValue(((Bookmark.Item)book).getUri());
                                sel.maybePlot(e.getModifiers());
                            } else {
                                ui.reviewBookmark(uri, e.getModifiers());
                            }
                        }
                    }
                });
                mi.setToolTipText(((Bookmark.Item)book).getUri());
                if (book.getIcon() != null) {
                    mi.setIcon(AutoplotUtil.scaleIcon(book.getIcon(), -1, 16));
                }
                menu.add(mi);
                continue;
            }
            Bookmark.Folder folder = (Bookmark.Folder)book;
            String title = book.getTitle();
            if (title.length() > 50) {
                title = title.substring(0, 50) + "...";
            }
            if (folder.getRemoteUrl() != null) {
                if (folder.getRemoteStatus() == 0) {
                    tooltip = "Bookmark folder based on contents of remote URL <br>%{URL}";
                    icon = null;
                } else if (folder.getRemoteStatus() == -1) {
                    tooltip = "Checking to see if remote bookmark list has changed.<br>%{URL}";
                    icon = AutoplotUI.BUSY_OPAQUE_ICON;
                } else {
                    if (folder.getRemoteStatus() != 1) throw new IllegalArgumentException("internal error...");
                    tooltip = "Using cached version because <br>remote folder based on contents of remote URL <br>%{URL}<br>which is not available. <br>" + folder.getRemoteStatusMsg();
                    icon = AutoplotUI.WARNING_ICON;
                }
            } else {
                tooltip = "";
                icon = null;
            }
            if (folder.isHidden()) continue;
            String titl = title.trim();
            if (titl.length() > 30 && treeDepth > 0) {
                titl = titl.substring(0, 17) + "..." + titl.substring(titl.length() - 10, titl.length());
            }
            DelayMenu subMenu = new DelayMenu(titl, folder.getBookmarks(), treeDepth + 1, sel, ui);
            subMenu.setIcon(icon);
            if (tooltip.contains("%{URL}")) {
                tooltip = tooltip.replace("%{URL}", folder.getRemoteUrl());
            }
            if (treeDepth == 0 && folder.getRemoteUrl() != null) {
                if (book.getDescription() != null && book.getDescription().length() > 0) {
                    String ttext = "<html><i>" + title + "<br>" + book.getDescription() + "</i>";
                    subMenu.setToolTipText(ttext + "<br>" + tooltip);
                } else if (tooltip.length() > 0) {
                    subMenu.setToolTipText("<html>" + tooltip);
                }
            }
            menu.add(subMenu);
        }
    }

    protected DelayMenu(final String label, final List<Bookmark> bookmarks, final int treeDepth, final DataSetSelector sel, final AutoplotUI ui) {
        super(label);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                logger.log(Level.FINEST, "resolving menu {0}...", label);
                DelayMenu.this.removeAll();
                DelayMenu.calculateMenu(DelayMenu.this, bookmarks, treeDepth, sel, ui);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }
}

